#==============================================================================
# * Scene_Credits
#------------------------------------------------------------------------------
# Scrolls the credits you make below. Original Author unknown.
#
## Edited by MiDas Mike so it doesn't play over the Title, but runs by calling
# the following:
#    $scene = Scene_Credits.new
#
## New Edit 3/6/2007 11:14 PM by AvatarMonkeyKirby.
# Ok, what I've done is changed the part of the script that was supposed to make
# the credits automatically end so that way they actually end! Yes, they will
# actually end when the credits are finished! So, that will make the people you
# should give credit to now is: Unknown, MiDas Mike, and AvatarMonkeyKirby.
#                                             -sincerly yours,
#                                               Your Beloved
# Oh yea, and I also added a line of code that fades out the BGM so it fades
# sooner and smoother.
#
## New Edit 24/1/2012 by Maruno.
# Added the ability to split a line into two halves with <s>, with each half
# aligned towards the centre. Please also credit me if used.
#
## New Edit 22/2/2012 by Maruno.
# Credits now scroll properly when played with a zoom factor of 0.5. Music can
# now be defined. Credits can't be skipped during their first play.
#
## New Edit 25/3/2020 by Maruno.
# Scroll speed is now independent of frame rate. Now supports non-integer values
# for SCROLL_SPEED.
#
## New Edit 21/8/2020 by Marin.
# Now automatically inserts the credits from the plugins that have been
# registered through the PluginManager module.
#==============================================================================
class Scene_Credits
  # Backgrounds to show in credits. Found in Graphics/Titles/ folder
  BACKGROUNDS_LIST       = ["credits1", "credits2", "credits3", "credits4", "credits5"]
  BGM                    = "Credits"
  SCROLL_SPEED           = 62   # Pixels per second , ajuster pour fitter avec la musique
  SECONDS_PER_BACKGROUND = 4
  TEXT_OUTLINE_COLOR     = Color.new(0, 0, 128, 255)
  TEXT_BASE_COLOR        = Color.new(255, 255, 255, 255)
  TEXT_SHADOW_COLOR      = Color.new(0, 0, 0, 100)
  NB_SPRITES_TO_PRELOAD = 30

  TOTAL_NB_FRAMES = 4000 #set manually, depends on music length

  FUSION_SPRITES_MAX_OPACITY=200
  NB_FRAMES_AT_MAX_OPACITY=30

  # This next piece of code is the credits.
  # Start Editing
  CREDIT = <<_END_

Pokémon Infinite Fusion
By Chardub (Frogzilla)

Programming / Game design:
Chardub

Fused Pokemon Sprites :
Japeal - Pokefusion 2
http://japeal.com/pkm

Special thanks to Aegide and Reizod for 
helping to download the autogenerated sprites 
and to the owners of Japeal for accepting to 
share their sprites.

Maps:
Chardub
Kiwikelly
Some of the maps were based on work by:
BenGames, Zeak6464

Gameplay / Story :
Chardub
Kiwikelly

Title screen and logo
Doctor Miawoo

Custom sprites collecting and handling
Kiwikelly, Payapon, Thornsoflight

Discord custom sprites coordination
avianAnnihilator<s>Blaquaza
BéBoutton<s>CaBiNE
CoramSun<s>hero.drawing
Howls<s>Ignus
Kiwi<s>Maelmc
Milchik the Miltank<s>Payapon
Pix<s>Rosemagwin
Thornsoflight

All of the custom fused Pokémon sprites 
were made by various members of the
Pokémon Infinite Fusion Discord

Including significant contributions from:

{SPRITER_CREDITS}

Other custom graphics:
Kiwikelly<s>Knuckles
UnworthyPie<s>Doctor Miawoo
Chardub<s>TCGrunler#4583

Elite 4 rematch teams
duskrd<s>anaconja<s>taraline

French translation
anthonygourmand
locpic_
blood.wolf58 (Willi)

The following free ressources were also used 
with their respective authors' consent:

Public use tileset graphics:
Alucus BoOmxBiG<s>chimcharsfireworkd
EpicDay<s>EternalTakai
Gallanty Heavy-Metal-Lover<s>Hek-el-grande
DirtyWiggles<s>iametrine
Jorginho<s>kizemaru-kurunosuke
KKKaito<s>kyle-dove
Minorthreat0987<s>Phyromatical
Pokemon-Diamond<s>rayd12smitty
Rossay<s>Shiney570
Spacemotion<s>Speedialga
ThatsSoWitty Thurpok<s>TyranitarDark
UltimoSpriter<s>WesleyFG

Public use music:    
Pokeli, TailDoll666100
Kazune Sawatari, sentsinkantéun,
Nanashima, CharizardTheMaster, The Zame Jack 

{INSERTS_PLUGIN_CREDITS_DO_NOT_REMOVE}

"Pokémon Essentials" was created by:
Flameguru
Poccil (Peter O.)
Maruno

With contributions from:
AvatarMonkeyKirby<s>MiDas Mike
Boushy<s>Near Fantastica
Brother1440<s>PinkMan
FL.<s>Popper
Genzai Kawakami<s>Rataime
Harshboy<s>SoundSpawn
help-14<s>the__end
IceGod64<s>Venom12
Jacob O. Wobbrock<s>Wachunga
KitsuneKouta<s>xLeD
Lisa Anthony<s>
and everyone else who helped out

"mkxp-z" by:
Roza
Based on MKXP by Ancurio et al.

"RPG Maker XP" by:
Enterbrain

This game was inspired by the original
fusion generator: 
alexonsager.alexonsager.net

All generated fusion sprites in this game
come from the Pokémon Fusion Generator:
https://japeal.com/pkm/

Pokémon is owned by:
The Pokémon Company
Nintendo
Affiliated with Game Freak

This is a non-profit fan-made game.
No copyright infringements intended.
_END_
# Stop Editing

  def main
    endCredits() if $PokemonSystem.on_mobile
    #-------------------------------
    # Animated Background Setup
    #-------------------------------
    @counter = 0.0   # Counts time elapsed since the background image changed
    @bg_index = 0
    @bitmap_height = Graphics.height   # For a single credits text bitmap
    @trim = Graphics.height / 10
    # Number of game frames per background frame
    @realOY = -(Graphics.height - @trim)
    @customSpritesList = getSpritesList()
    #-------------------------------
    # Credits text Setup
    #-------------------------------
    plugin_credits = ""
    PluginManager.plugins.each do |plugin|
      pcred = PluginManager.credits(plugin)
      plugin_credits << "\"#{plugin}\" v.#{PluginManager.version(plugin)} by:\n"
      if pcred.size >= 5
        plugin_credits << pcred[0] + "\n"
        i = 1
        until i >= pcred.size
          plugin_credits << pcred[i] + "<s>" + (pcred[i + 1] || "") + "\n"
          i += 2
        end
      else
        pcred.each { |name| plugin_credits << name + "\n" }
      end
      plugin_credits << "\n"
    end
    CREDIT.gsub!(/\{INSERTS_PLUGIN_CREDITS_DO_NOT_REMOVE\}/, plugin_credits)
    CREDIT.gsub!(/{SPRITER_CREDITS}/, format_names_for_game_credits())

    credit_lines = CREDIT.split(/\n/)

    #-------------------------------
    # Make background and text sprites
    #-------------------------------
    viewport = Viewport.new(0, 0, Graphics.width, Graphics.height)
    viewport.z = 99999
    text_viewport = Viewport.new(0, @trim, Graphics.width, Graphics.height - (@trim * 2))
    text_viewport.z = 99999
    @background_sprite = IconSprite.new(0, 0)
    @background_sprite.setBitmap("Graphics/Titles/" + BACKGROUNDS_LIST[0])
    @credit_sprites = []
    @total_height = credit_lines.size * 32
    lines_per_bitmap = @bitmap_height / 32
    num_bitmaps = (credit_lines.size.to_f / lines_per_bitmap).ceil
    for i in 0...num_bitmaps
      credit_bitmap = Bitmap.new(Graphics.width, @bitmap_height)
      pbSetSystemFont(credit_bitmap)
      for j in 0...lines_per_bitmap
        line = credit_lines[i * lines_per_bitmap + j]
        next if !line
        line = line.split("<s>")
        xpos = 0
        align = 1   # Centre align
        linewidth = Graphics.width
        for k in 0...line.length
          if line.length > 1
            xpos = (k == 0) ? 0 : 20 + Graphics.width / 2
            align = (k == 0) ? 2 : 0   # Right align : left align
            linewidth = Graphics.width / 2 - 20
          end
          credit_bitmap.font.color = TEXT_SHADOW_COLOR
          credit_bitmap.draw_text(xpos,     j * 32 + 8, linewidth, 32, line[k], align)
          credit_bitmap.font.color = TEXT_OUTLINE_COLOR
          credit_bitmap.draw_text(xpos + 2, j * 32 - 2, linewidth, 32, line[k], align)
          credit_bitmap.draw_text(xpos,     j * 32 - 2, linewidth, 32, line[k], align)
          credit_bitmap.draw_text(xpos - 2, j * 32 - 2, linewidth, 32, line[k], align)
          credit_bitmap.draw_text(xpos + 2, j * 32,     linewidth, 32, line[k], align)
          credit_bitmap.draw_text(xpos - 2, j * 32,     linewidth, 32, line[k], align)
          credit_bitmap.draw_text(xpos + 2, j * 32 + 2, linewidth, 32, line[k], align)
          credit_bitmap.draw_text(xpos,     j * 32 + 2, linewidth, 32, line[k], align)
          credit_bitmap.draw_text(xpos - 2, j * 32 + 2, linewidth, 32, line[k], align)
          credit_bitmap.font.color = TEXT_BASE_COLOR
          credit_bitmap.draw_text(xpos,     j * 32,     linewidth, 32, line[k], align)
        end
      end
      credit_sprite = Sprite.new(text_viewport)
      credit_sprite.bitmap = credit_bitmap
      credit_sprite.z      = 9998
      credit_sprite.oy     = @realOY - @bitmap_height * i
      @credit_sprites[i] = credit_sprite
    end
    #-------------------------------
    # Setup
    #-------------------------------
    # Stops all audio but background music
    previousBGM = $game_system.getPlayingBGM
    pbMEStop
    pbBGSStop
    pbSEStop
    pbBGMFade(2.0)
    pbBGMPlay(BGM)
    Graphics.transition(20)
    loop do
      Graphics.update
      Input.update
      update
      break if $scene != self
    end
    pbBGMFade(2.0)
    Graphics.freeze
    viewport.color = Color.new(0, 0, 0, 255)   # Ensure screen is black
    Graphics.transition(20, "fadetoblack")
    @background_sprite.dispose
    @credit_sprites.each { |s| s.dispose if s }
    text_viewport.dispose
    viewport.dispose
    $PokemonGlobal.creditsPlayed = true
    pbBGMPlay(previousBGM)
  end

  def getSpritesList()
    spritesList = []
    $PokemonGlobal.alt_sprite_substitutions.each_value do |value|
      if value.is_a?(PIFSprite)
        spritesList << value
      end
    end
    selected_spritesList = spritesList.sample(NB_SPRITES_TO_PRELOAD)
    spriteLoader = BattleSpriteLoader.new
    for sprite in selected_spritesList
      spriteLoader.preload(sprite)
    end

    return selected_spritesList
  end

  # Check if the credits should be cancelled
  def cancel?
    if Input.trigger?(Input::USE) && $PokemonGlobal.creditsPlayed
      endCredits
      return true
    end
    return false
  end

  def endCredits
    $scene = Scene_Map.new
    pbBGMFade(1.0)
  end

  # Checks if credits bitmap has reached its ending point
  def last?
    if @realOY > @total_height + @trim
      $scene = ($game_map) ? Scene_Map.new : nil
      pbBGMFade(2.0)
      return true
    end
    return false
  end

  def update
    delta = Graphics.delta_s
    @counter += delta
    @sprites_counter = 0 if !@sprites_counter
    #@background_sprite.setBitmap("Graphics/Titles/" + BACKGROUNDS_LIST[@bg_index])
    # # Go to next slide
    @frames_counter = 0 if !@frames_counter
    @frames_counter+=1

    stopShowingSprites = @frames_counter >= (TOTAL_NB_FRAMES-300)
    pbBGSStop if @frames_counter > TOTAL_NB_FRAMES

    spriteLoader = BattleSpriteLoader.new
    if @counter >= SECONDS_PER_BACKGROUND && @customSpritesList.length > 0 && !stopShowingSprites
      @sprites_counter=0
      randomSprite = @customSpritesList.sample
      @customSpritesList.delete(randomSprite)
      @background_sprite.setBitmapDirectly(spriteLoader.load_pif_sprite(randomSprite))
      @background_sprite.x = rand(0..300)
      @background_sprite.y = rand(0..200)
      @counter -= SECONDS_PER_BACKGROUND
      @background_sprite.opacity = 50
      @fadingIn=true
    end
    if @fadingIn
      if @background_sprite.opacity < FUSION_SPRITES_MAX_OPACITY
        @background_sprite.opacity +=5
      else
        @fadingIn=false
      end

    else
      @sprites_counter += 1
      if @sprites_counter >= NB_FRAMES_AT_MAX_OPACITY
        @background_sprite.opacity-=3
      end
    end


    return if cancel?
    return if last?
    @realOY += SCROLL_SPEED * delta
    @credit_sprites.each_with_index { |s, i| s.oy = @realOY - @bitmap_height * i }
  end
end
